Moment_estimators = function(x){
n = length(x)
A1 = mean(x)
A2 = mean(x^2)

alpha_1 = A1^2 / (A2 - A1 - A1^2)
beta_1 = A1 / (A2 - A1 - A1^2)

res = c(alpha_1, beta_1)
}

Pearson_chisquare_test = function(nn, p, r){
# nn - frequencies
# p  - theoretical probabilities
# r  - number of unknown parameters

n = sum(nn)
m = length(nn)
K = sum((nn - n * p)^2 / (n * p))
df = m - 1 - r
P_value = 1 - pchisq(K, df = df)

res = data.frame(Chisquare = K, P_value = P_value, df = df, m = m, n = n)
}

Newtons = function(fun, p, x, ep=1e-5, it_max=20){
    index = 0; k = 1
    while (k <= it_max){
        p1 = p; obj = fun(p, x);
        p  = p - solve(obj$J, obj$f);
        norm = sqrt((p-p1) %*% (p-p1))
        if (norm < ep){
            index = 1; break
        }
        k = k + 1
    }
    obj = fun(p, x);
    list(root=p, it=k, index=index, FunVal=obj$f)
}

moment_fun = function(p, x){
alpha = p[1]
beta = p[2]

f1 = log(beta) + mean(digamma(x + alpha)) - digamma(alpha) - log(1 + beta)
f2 = alpha / beta - (mean(x) + alpha) / (1 + beta)
f = c(f1, f2)

J11 = mean(trigamma(x + alpha)) - trigamma(alpha)
J12 = 1 / (beta * (1 + beta))
J21 = J12
J22 = - alpha / beta^2 + (mean(x) + alpha) / (1 + beta)^2
J = matrix(c(J11, J12, 
			 J21, J22), nrow=2, byrow = TRUE)
			 
res = list(f=f, J=J)
}

Compute_PostDist_Estimators_PESLs_new = function(alpha, beta, x_np1){
alpha1 = alpha + x_np1
beta1 = beta + 1

PostDist_theta = rgamma(n = 1e4, shape = alpha1, rate = beta1)
delta_s = (alpha1 - 1) / beta1
delta_2 = alpha1 / beta1
PESL_s = - log(alpha1 - 1) + digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) - log(alpha1) + digamma(alpha1)

res = list(
PostDist_theta = PostDist_theta,
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Compute_Estimators_PESLs_new = function(alpha, beta, x_np1){
alpha1 = alpha + x_np1
beta1 = beta + 1

delta_s = (alpha1 - 1) / beta1
delta_2 = alpha1 / beta1
PESL_s = - log(alpha1 - 1) + digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) - log(alpha1) + digamma(alpha1)

res = data.frame(
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Compute_mean_variance = function(alpha, beta){
E = alpha / beta
V = (alpha * beta + alpha) / beta^2

res = data.frame(Theoretical_Expectation = E, Theoretical_Variance = V)
}

Generate_Matrix_Latex = function(A){
m = nrow(A)
n = ncol(A)

C = rep("c", n, sep=""); C
temp = "[c]{"
for (i in 1:n){
temp = paste(temp, C[i], sep="")
}
temp = paste(temp, "}", sep="")

B = matrix("0", nrow = m, ncol = 2*n); B
for (i in 1:m){
	for (j in 1:n){
		B[i, 2*j-1] = A[i, j]
		B[i, 2*j]   = "&"
	}
}
B[, 2*n] = "\\\\"
B[m, 2*n] = ""
B

One = "\\begin{tabular}"
Two = temp
Three = B
Four = "\\end{tabular}"

cat(One, "\n", Two, "\n"); for (i in 1:m) cat(B[i, ], "\n");  cat(Four, "\n")
}

plot_estimator = function(delta_s, delta_2, parameter, para_name, xlab, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(delta_s, delta_2)
#ylim=c(0:1)
plot(parameter, delta_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "Estimator", sub = sub)
lines(parameter, delta_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, delta_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("delta_s", "delta_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/P-G_Estimator_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/P-G_Estimator_", para_name, "_change", sep = ""), type = c("jpg"))
}

plot_PESL = function(PESL_s, PESL_2, parameter, para_name, xlab, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(PESL_s, PESL_2)
plot(parameter, PESL_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "PESL", sub = sub)
lines(parameter, PESL_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, PESL_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("PESL_s", "PESL_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/P-G_PESL_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/P-G_PESL_", para_name, "_change", sep = ""), type = c("jpg"))
}

data_outline = function(x){
   n = length(x)
   m = mean(x)
   v = var(x)
   s = sd(x)
   me = median(x)
   cv = 100*s/m
   css = sum((x-m)^2)
   uss = sum(x^2)
   R =  max(x)-min(x)
   R1 = quantile(x, 3/4)-quantile(x, 1/4)
   sm = s/sqrt(n)
   g1 = n/((n-1)*(n-2))*sum((x-m)^3)/s^3
   g2 = ((n*(n+1))/((n-1)*(n-2)*(n-3))*sum((x-m)^4)/s^4
          - (3*(n-1)^2)/((n-2)*(n-3)))
   data.frame(N=n, Mean=m, Var=v, std_dev=s, Median=me, 
        std_mean=sm, CV=cv, CSS=css, USS=uss, R=R, 
        R1=R1, Skewness=g1, Kurtosis=g2, row.names=1)
}

Marginal_density_alpha_beta = function(x, alpha, beta){
res = gamma(x + alpha) * beta^alpha / (gamma(x + 1) * gamma(alpha) * (1 + beta)^(x + alpha))
}
